<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model 
{

    protected $table = 'warehouses';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'email', 'password', 'address', 'latitude', 'longitude', 'warehouse_data', 'status', 'city_id');
    protected $hidden = array('password');

    public function admins()
    {
        return $this->hasMany('Admin');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}